<?php
/*
Plugin Name: WP-Date FR
Plugin URI: http://www.skyminds.net/wordpress-plugins/wp-date-fr/
Description: This plugin transforms the standard date issued by the_time() into the French date format (DD MM YYYY).
Version: 1.2
Author: Matthieu Biscay
Author URI: http://www.skyminds.net/wordpress-plugins/
*/

/* --- INSTALL NOTES --- 
1- Activate the plugin
2- Provided your template files features the_time() or the_date(), WordPress is now using the French date format (DD MM YYYY).
More info on the plugin page : http://www.skyminds.net/wordpress-plugins/wp-date-fr/

CHANGELOG
v1.2 : added support for UTF-8.
*/

add_filter('the_time', 'sky_date_fr');
add_filter('the_date', 'sky_date_fr');

function sky_date_fr($sky_all='')
{           
    setlocale(LC_ALL, 'fr_FR@euro', 'fr_FR', 'fra_fra');   
    $sky_date = get_the_time('Ymd');   
    $sky_time = get_the_time('H:i');    
    $sky_all =  utf8_encode(strftime("%A %d %B %Y", strtotime($sky_date))) . ' &agrave; ' . $sky_time; 
    return $sky_all;
}
?>