<?php
/*
Plugin Name: Song Displayer
Plugin URI: http://www.skyminds.net/wordpress-plugins/song-displayer/
Description: This plugin allows you to display the song that is currently playing in your Winamp playlist. You either need <a href="http://www.winamp.com/">Winamp</a> and the <a href="http://www.oddsock.org/tools/dosomething/">DoSomething plugin</a> or <a href="http://www.spacialaudio.com/?page=sam-broadcaster">SAM Broadcaster</a>. See <a href="http://www.skyminds.net/2006/05/10/song-displayer-a-wordpress-plugin-to-display-on-your-blog-what-winamp-or-sam-broadcaster-is-playing/">installation instructions</a>.
Version: 0.4
Author: Matthieu Biscay
Author URI: http://www.skyminds.net/wordpress-plugins/


INSTALLATION INSTRUCTIONS
=========================
1) Copy this file into your wp-contents/plugins directory.

2) Activate the plugin on the Plugins page.

3) Edit the plugin and configure the variables in the Setup section to reflect your settings.

4) Add <?php if(function_exists('show_playlist')) { show_playlist(1, " - ", "<br />") ; } ?> where you want to display the song info (in sidebar.php for example).

5) Detailed guides with screenshots can be found here : 
-------- in English : http://www.skyminds.net/2006/05/10/song-displayer-a-wordpress-plugin-to-display-on-your-blog-what-winamp-or-sam-broadcaster-is-playing/
-------- in French : http://www.skyminds.net/2005/02/12/song-displayer-plugin-wordpress-pour-afficher-ce-que-joue-winamp-ou-sam-broadcaster/


CHANGELOG
=========================
v0.4   - added support for SAM Broadcaster.
v0.3   - bug fix version. Now supports WP 1.5.
v0.2   - initial release
*/ 


function show_playlist($number, $title_separator, $line_separator)
{
//==================================================================#
//=========================== SETUP ================================#
//==================================================================#
//	Path to the generated playlist from your blog root. Vital!
//==================================================================#

   $playlist = "/home/cpanel/public_html/thunderstruck/mp3-out.php";

//==================================================================#
//	If file hasn't been modified in the last 7 minutes, assume 
//      Winamp is turned off. Modify to suits your needs. Number is 
//      expressed in seconds (7 min = 420 seconds).
//==================================================================#

   $delay = 420;

//==================================================================#
//	If you have a Shoutcast/IceCast stream, enter its URL below.
//      Otherwise, leave empty.
// Example : 'http://thunderstruck.dyndns.org:8000/stream.ogg.m3u';
//==================================================================#
   
   $stream = 'http://thunderstruck.dyndns.org:8000/stream.ogg.m3u';

//==================================================================#
//========================END OF SETUP =============================#
//==================================================================#
 
   //==================================================================# 
   //	Test if file has been updated recently : check against the
   //   $delay value.
   //==================================================================#
   $myplaylist = '';
   $line = @file($playlist);
   $last_update = date ("U", @filemtime("$playlist")); 
   if (!$line || $last_update < time()-$delay)
   {
       $myplaylist = "Radio is off !";
       echo $myplaylist;
   }
   else
   {
      for ($i=0 ; ; $i++)
      {
         if($i == $number)
         {
            break;
         }

         //==================================================================# 
         //	Grab variables from your generated playlist file.
         //==================================================================#

         $this_song = explode( '||', $line[$i] );
         $artist   = $this_song[0];
         $title    = $this_song[1];
         $album    = trim($this_song[2]);
         $songname = trim($this_song[3]);

         //==================================================================# 
         //	Display the filename as it appears in the playlist if 
         //     the ID3 Tags are not available.
         //==================================================================#

         if(empty($artist) || empty($title))
         {
            $myplaylist = "<a href='$stream'>$songname</a>";
         }
         else
         {
            $myplaylist = $artist . $title_separator . "\n";
        
            //==================================================================# 
            //	Print album title if available.
            //==================================================================#

            if(isset($album))
            {
              $myplaylist.= "<acronym title=\"Album '" . $album . "'\">" . $title . "</acronym>" . $line_separator . "\n";
            }
            else
            {
              $myplaylist.= $title . $line_separator . "\n";
            } 
 
            //==================================================================# 
            //	Embed stream URL.
            //==================================================================#           

            $myplaylist = "<a href='$stream'>$myplaylist</a>"; 
         }        
         echo $myplaylist;
      }
   }
}
?>
