<?php
/*
Plugin Name: Pimp My Login
Plugin URI: http://www.skyminds.net/wordpress-plugins/pimp-my-login/
Description: Lets you display your custom logo, linked to the home URI with your custom title.
Version: 1.6
Author: Matt Biscay
Author URI: http://www.skyminds.net/
*/

// Load our CSS with our images, located in /pimp-my-login/images/
function sky_pimpmylogin_css()
{
	$blog_version = get_bloginfo('version');
	if($blog_version < 2.5)
	{
		echo '<link rel="stylesheet" type="text/css" href="' . get_settings('siteurl') . '/wp-content/plugins/' . dirname(plugin_basename(__FILE__)) . '/pimp-my-login-legacy.css" />';
	}
	elseif($blog_version >= 2.5 && $blog_version <= 2.7)
	{
		echo '<link rel="stylesheet" type="text/css" href="' . get_settings('siteurl') . '/wp-content/plugins/' . dirname(plugin_basename(__FILE__)) . '/pimp-my-login-2.7.css" />';
	}
	elseif($blog_version >= 2.8 && $blog_version < 3.3)
	{
		echo '<link rel="stylesheet" type="text/css" href="' . get_settings('siteurl') . '/wp-content/plugins/' . dirname(plugin_basename(__FILE__)) . '/pimp-my-login-3.2.1.css" />';
	}
	elseif($blog_version >= 3.3)
	{
		echo '<link rel="stylesheet" type="text/css" href="' . get_settings('siteurl') . '/wp-content/plugins/' . dirname(plugin_basename(__FILE__)) . '/pimp-my-login.css" />';
	}
}

// Link the login logo to our site !
function sky_pimpmylogin_url() {  return get_option('siteurl') . '/';  }

// Change the logo title to something more personal, like the blog title/description !
function sky_pimpmylogin_title() {  return get_option('blogname') . ' ' . get_option('blogdescription'); }

add_action('login_head', 'sky_pimpmylogin_css', 100);
add_filter('login_headerurl', 'sky_pimpmylogin_url'); 
add_filter('login_headertitle', 'sky_pimpmylogin_title'); 
?>
