<?php
/****************************************************************
Audioscrobbler song submitter for SpacialAudio's SAM Broadcaster

By: disq <disqkk@gmail.com>
Modified by : Matt Biscay (www.skyminds.net)
version: 0.2 (released 20071015)

Requirements:
-- SAM (tested with SAM4 but should work ok with previous versions)
-- A html template in SAM, see below
-- PHP command-line, with curl module enabled

SAM html template to use:
--cut--
|$song.title$
|$song.artist$
|$song.album$
|$song.mmss$
--cut--

Please edit your configuration below.
*/
/*********************** CONFIGURATION STARTS HERE ********************************/
//path to the html file sam generates (template is above)
DEFINE("htmlfile", 'C:\Program Files\SpacialAudio\SAMBC\samHTMweb\lastfm.html'); 

//path to logfile if you want logs
DEFINE("logfile", ''); 

//your last.fm username
DEFINE("lastfmuser", 'azerty'); 

//your last.fm password (you can remove the "md5" expression and add the md5 of the password)
DEFINE("lastfmpassmd5", md5('azerty')); 

//the additional time before the song is submitted. you can set it to time it takes to crossfade in the next song
DEFINE("songgapsecs", 10);

//http timeout, 5-10 is ok
DEFINE("timeoutsecs", 10); 

/*********************** CONFIGURATION ENDS HERE ********************************/

DEFINE("clientid", "sam");
DEFINE("clientver", "0.2");

set_time_limit(0);

function logline($line, $writetofile=1)
{
	$ls=date ("y-m-d H:i:s")." | ".$line."\n";
	echo $ls;
	if ($writetofile!=1 || logfile=="") return(1);
	$f=@fopen(logfile, "a");
	if ($f!=0)
	{
		flock($f, 2);
		fputs($f, $ls);
		flock($f, 3);
		fclose($f);
		return(0);
	}
	return(1);
}

function geturl($url, $fixCRLF=1)
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_FAILONERROR, 1);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
	curl_setopt($ch, CURLOPT_TIMEOUT, timeoutsecs);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
	$o=curl_exec($ch); 
	curl_close($ch);

	if ($fixCRLF==1)
	{
		$o=str_replace("\r", "\n", $o);
		$o=str_replace("\n\n", "\n", $o);
	}
	return($o);
}

function login()
{
	$wait=60;
	while(true)
	{
		logline("Logging in...");
		$ts=time();
		$r=array(0=>"unknown", "", "", "");

	//1.2
	//	$ret=geturl("http://post.audioscrobbler.com/?hs=true&p=1.2&c=".rawurlencode(clientid)."&v=".rawurlencode(clientver)."&u=".rawurlencode(lastfmuser)."&t=".$ts."&a=".md5(lastfmpassmd5.$ts));
	//1.1
		$ret=geturl("http://post.audioscrobbler.com/?hs=true&p=1.1&c=".rawurlencode(clientid)."&v=".rawurlencode(clientver)."&u=".rawurlencode(lastfmuser)."&t=".$ts);

	$r=explode("\n", $ret);
//	logline("ret:*".$r[0]."*");
	$t=explode(" ", $r[0]);
	if ($t[0]=="UPDATE")
		{
		logline("New version of plugin available at ".$t[1]);
		$r[0]="UPTODATE";
		break;
		}
	else if ($r[0]=="UPTODATE")
		{
		logline("The client is up to date.");
		break;
		}
	
//	if ($r[0]=="OK") break; //1.2
	if ($r[0]=="BADAUTH" || $r[0]=="BADUSER")
		{
		logline("ERROR: Authentication failed, check lastfmuser/lastfmpass");
		exit;
		}
	logline("Waiting for ".($wait/60)." minutes before retrying");
	sleep($wait);
	$wait*=2;
	if ($wait>120) $wait=120;
	}
if ($r[0]=="UPTODATE")
	{
	$t=explode(" ", $r[3]);
	if ($t[0]=="INTERVAL") $r[3]=(int)$t[1];
	}
else
	{
	logline("ERROR: unknown");
	exit;
	}
	
return($r);
}

unset($submitqueue);

function checksubmitsong($t)
{
global $lo, $submitqueue;

@reset($submitqueue);
while($fi=@each($submitqueue))
	{
	$ti=$fi['key'];
	if ($t>$ti)
		{
		$o=submitsong($fi['value']);
		logline("submitsong returned $o (int=".$lo[3].")");
		if ($o=="OK")
			{
			unset($submitqueue[$ti]);
			}
		}
	}
}

$lastsubmittime=0;

function submitsong($info, $nowplaying=0 /*1.2*/, $recurse=1)
{
global $lo, $lastsubmittime;

if ($lastsubmittime>0 && $lo[3]>0)
	{
	if ($lastsubmittime+$lo[3]>time()) return("WAIT");
	}

$app=" for stats";
if ($nowplaying!=0) { $app=" for now playing"; $nowplaying=1; }

logline("Submitting ".$info[0]."/".$info[1]."/".$info[2]."/".$info[3].$app);
$so=$info[0]."/".$info[1];

//return;

$info[0]=utf8_encode($info[0]);
$info[1]=utf8_encode($info[1]);
$info[2]=utf8_encode($info[2]);
$info[3]=utf8_encode($info[3]);

/*
//1.2
if ($nowplaying==0)
	$pf="s=".urlencode($lo[1])."&n[0]=&o[0]=P&r[0]=&a[0]=".urlencode($info[1])."&t[0]=".urlencode($info[0])."&b[0]=".urlencode($info[2])."&m[0]=&l[0]=".urlencode($info[4])."&i[0]=".urlencode($info[5])."&";
else
	$pf="s=".urlencode($lo[1])."&n=&a=".urlencode($info[1])."&t=".urlencode($info[0])."&b=".urlencode($info[2])."&m=&l=".urlencode($info[4])."&";
*/

$pf="u=".urlencode(lastfmuser)."&s=".urlencode(md5(lastfmpassmd5.$lo[1]))."&a[0]=".urlencode($info[1])."&t[0]=".urlencode($info[0])."&b[0]=".urlencode($info[2])."&m[0]=&l[0]=".urlencode($info[4])."&i[0]=".urlencode(gmdate("Y-m-d H:i:s", $info[5]))."&";

//logline("pf is ".$pf);

$ch = curl_init();
//curl_setopt($ch, CURLOPT_URL, $lo[2+$nowplaying]); //1.2
curl_setopt($ch, CURLOPT_URL, $lo[2]);//1.1
curl_setopt($ch, CURLOPT_FAILONERROR, 1);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, timeoutsecs);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
curl_setopt($ch, CURLOPT_HEADER, 0);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $pf);
$o=curl_exec($ch);
$od="";
//logline("err=".curl_errno($ch));
//logline("really got:$o*");
if (curl_errno($ch)!=0)
	{
	$o="curlERR";
	$od=curl_error($ch);
	}
curl_close($ch);

/*1.1*/
$oo=explode("\n", $o);
$o=$oo[0];

$t=explode(" ", $oo[1]);
if ($t[0]=="INTERVAL") $lo[3]=(int)$t[1];

/*
if ($o=="BADSESSION" && $recurse==1) //1.2
	{
	$lo=login();
	return(submitsong($info, $nowplaying, 0));
	}
*/
if ($o!="OK")
	{
	logline("Warning: Could not submit last song (".$so.")".$app);
	}

if ($o=="BADAUTH")
	{
	logline("ERROR: Authentication failed, check lastfmuser/lastfmpass");
	exit;
	}
/*else if ($o=="BADSESSION") //1.2
	{
	logline("ERROR: Got a BADSESSION the second time");
	}
*/else if ($o=="curlERR")
	{
	logline("ERROR: Got error from AS url (".$od.", ".$lo[3].")");
	}
else if ($o!="OK")
	{
	logline("got:$o*");
	}

return($o);
}

@unlink(htmlfile);

$lo=login();
//print_r($lo);

$lastmtime=0;
$submittime=0;
unset($lastinfo);
while(1)
	{
	$t=time();

	checksubmitsong($t);

	clearstatcache();
	$mt=@filemtime(htmlfile);
	if ($mt===FALSE || $mt<1)
		{
//		logline("htmlfile not found, will retry in 5");
		sleep(5);
		continue;
		}
	if ($mt==$lastmtime)
		{
//		logline("htmlfile unchanged");
		sleep(5);
		continue;
		}
	$da="";
	$f=@fopen(htmlfile, "r");
	if ($f!=0)
		{
		$da=@fread($f, 4096);
		fclose($f);
		@unlink(htmlfile);
		}
	else
		{
		logline("error opening htmlfile, will retry in 5");
		sleep(5);
		continue;
		}
	$lastmtime=$mt;
	$da=str_replace("\r", "\n", $da);
	$da=str_replace("\n\n", "\n", $da);
	$d=explode("\n", $da);
	$d[0]=trim($d[0], "|"); // title
	$d[1]=trim($d[1], "|"); // artist
	$d[2]=trim($d[2], "|"); // album
	$d[3]=trim($d[3], "|"); // time
	
	$tmp=explode(":", $d[3]);
	$xx=count($tmp);
	$secs=0;
	for($i=$xx-1;$i>=0;$i--)
		{
		$digit=(int)$tmp[$i];
		if ($digit<1) continue;
		$curdi=$xx-$i-1;
		if ($curdi>0) $di=$digit*$curdi*60;
						 else $di=$digit;
		$secs+=$di;
		}

	if (($d[0]=="" && $d[1]=="") || $secs<=30)
		{
		logline("skipping song submission for ".$d[0]."/".$d[1]."/".$d[3]);
		continue;
		}

	$d[4]=$secs;
	//$d[5]=$lastmtime;
	$d[5]=$t;

	if ($secs/2>240) $tosec=240;
							else $tosec=$secs/2;
	$submittime=$t+$tosec+songgapsecs;
	$submitqueue[$submittime]=$d;
	
//	print_r($lastinfo);
//	logline("submittime is t + ".($submittime-$t)." secs");
	sleep(5);
	}
?>